
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Allocation / Desc"
	SimpleWait ( )
#ENDIF

Declare Sub Desc_Destroy ( Desc As Story_Desc_Type )

Declare Sub Multi_Desc_Destroy ( Desc ( Any ) As Story_Desc_Type )

Declare Sub Multi_Desc_Load ( Desc ( Any ) As Story_Desc_Type, ByRef Buffer As String = "" )

Declare Sub Desc_Load ( Desc As Story_Desc_Type, ByRef Buffer As String = "" )

Sub Desc_Destroy ( Desc As Story_Desc_Type )
			
	With Desc
	
		'If .Active > 0 Then
				
			.Text = ""
			.Active = 0
			
		'End If
	
	End With
	
End Sub

Sub Multi_Desc_Destroy ( Desc ( Any ) As Story_Desc_Type )
	
	Dim As Long Index = 0

	If UBound( Desc, 1 ) < 0 Then
		Erase Desc
		ReDim Desc ( -1 To -1 )
		Exit Sub
	End If
	
	For Index = 0 To Ubound ( Desc, 1 ) Step 1
		
		Desc_Destroy ( Desc ( Index ) )

	Next Index

	Erase Desc
	ReDim Desc ( -1 To -1 )

End Sub

Sub Multi_Desc_Load ( Desc ( Any ) As Story_Desc_Type, ByRef Buffer As String = "" )

	Dim As Long Index = 0

	/' Description '/
	
	ReDim Desc ( 1 To 4 )
	
	For Index = 0 To Ubound ( Desc, 1 ) Step 1
	
		Desc_Load ( Desc ( Index ), Buffer )
						
	Next Index
	
End Sub

Sub Desc_Load ( Desc As Story_Desc_Type, ByRef Buffer As String = "" )
	
	/' Description '/
	
	With Desc
		
		.Text = Trim ( Trim ( Prefix ( CRLF, Buffer ), QUOT ), SP )
		
		Buffer = Suffix ( CRLF, Buffer )
		
		.Active = 1
			
	End With	
	
End Sub
